/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.AnalyzeConsoleIntCodeConstants;
import com.ibm.hwmca.base.updates.AnalyzeConsoleIntCodeTasklet;
import com.ibm.hwmca.base.updates.BrowseDataBean;
import com.ibm.hwmca.base.updates.InternalCodeFixBean;
import com.ibm.hwmca.base.updates.MCF;
import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.Update;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class AnalyzeCodeFixInfoTasklet
extends PanelTasklet
implements AnalyzeConsoleIntCodeConstants,
UpdatesErrorIds {
    private static final String TRACE_MASKT = "XMCFACFT";
    private static final String TRACE_MASKF = "XMCFACFF";
    private static final String TRACE_MASKD = "XMCFACFD";
    private PanelHandler currentPanel;
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "AnalyzeCodeFixInfoTasklet");
    private PanelHandler InternalCodeChangePanelHandler = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(AnalyzeCodeFixInfoTasklet.TRACE_MASKT, "-> AnalyzeCodeFixInfoTasklet.InternalCodeChangePanelHandler.service()");
            if (request.isDisposed() || request.isCanceled()) {
                response.dispose();
            } else {
                String updateFileName = (String)request.getData("file");
                Trace.trace(AnalyzeCodeFixInfoTasklet.TRACE_MASKF, "   AnalyzeCodeFixInfoTasklet.InternalCodeChangePanelHandler.service() - The Update file: '" + updateFileName + "'");
                byte[] bArray = null;
                try {
                    File inputFile = new File(updateFileName);
                    FileInputStream in = new FileInputStream(inputFile);
                    bArray = new byte[(int)inputFile.length()];
                    int bytes = in.read(bArray);
                    in.close();
                }
                catch (IOException ioe) {
                    Trace.trace(AnalyzeCodeFixInfoTasklet.TRACE_MASKF, "   AnalyzeCodeFixInfoTasklet.InternalCodeChangePanelHandler.service() - caught IOException: " + ioe);
                }
                catch (SecurityException se) {
                    Trace.trace(AnalyzeCodeFixInfoTasklet.TRACE_MASKF, "   AnalyzeCodeFixInfoTasklet.InternalCodeChangePanelHandler.service() - caught exception on length(): " + se);
                }
                if (null != bArray) {
                    String fileText = new String(bArray);
                    BrowseDataBean bean = new BrowseDataBean();
                    bean.setBrowseDataOutput(fileText);
                    bean.setTitle(updateFileName);
                    AnalyzeCodeFixInfoTasklet.this.currentPanel = AnalyzeCodeFixInfoTasklet.this.BrowseDataPanelHandler;
                    response.openModalChild("com.ibm.hwmca.base.updates.res.AnalyzeConsoleIntCodeRes", "BrowseDataPanel", bean);
                } else {
                    response.noAction();
                }
            }
            Trace.trace(AnalyzeCodeFixInfoTasklet.TRACE_MASKT, "<- AnalyzeCodeFixInfoTasklet.InternalCodeChangePanelHandler.service()");
        }
    };
    private PanelHandler BrowseDataPanelHandler = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(AnalyzeCodeFixInfoTasklet.TRACE_MASKT, "-> AnalyzeCodeFixInfoTasklet.BrowseDataPanelHandler.service()");
            AnalyzeCodeFixInfoTasklet.this.currentPanel = AnalyzeCodeFixInfoTasklet.this.InternalCodeChangePanelHandler;
            response.dispose();
            Trace.trace(AnalyzeCodeFixInfoTasklet.TRACE_MASKT, "<- AnalyzeCodeFixInfoTasklet.BrowseData.service()");
        }
    };

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block18: {
            Trace.trace(TRACE_MASKT, "-> AnalyzeCodeFixInfoTasklet.service()");
            try {
                if (request.isInitialRequest()) {
                    List modules;
                    ArrayList filenames;
                    String[] rowData = (String[])request.getData("rowData");
                    AnalyzeConsoleIntCodeTasklet parent = (AnalyzeConsoleIntCodeTasklet)this.getParent();
                    Update update = parent.getSelectedUpdate();
                    InternalCodeFixBean bean = new InternalCodeFixBean();
                    try {
                        bean.setFileNamOutput(((MCF)update).getControlFileName());
                        bean.setAuthorOutput(((MCF)update).getAuthor());
                        bean.setStagingAreaPath(((MCF)update).getStagingAreaPath());
                        Trace.trace(TRACE_MASKD, "  File name: " + ((MCF)update).getControlFileName());
                        Trace.trace(TRACE_MASKD, "    Staging area path: " + ((MCF)update).getStagingAreaPath());
                        Trace.trace(TRACE_MASKD, "  Author: " + ((MCF)update).getAuthor());
                    }
                    catch (ClassCastException cce) {
                        Trace.trace(TRACE_MASKF, "   AnalyzeCodeFixInfoTasklet.service() - caught exception: " + cce);
                        bean.setFileNamOutput("");
                        bean.setAuthorOutput("");
                        bean.setStagingAreaPath("");
                        Trace.trace(TRACE_MASKD, "   AnalyzeCodeFixInfoTasklet.service() - File name:  [empty string]  Author:  [empty string]");
                    }
                    bean.setGrpNumOutput(rowData[2]);
                    bean.setStatusOutput(rowData[3]);
                    bean.setDateOutput(rowData[4]);
                    bean.setTimeOutput(rowData[5]);
                    bean.setDescriptOutput(rowData[6]);
                    Trace.trace(TRACE_MASKD, "  Level: " + rowData[2]);
                    Trace.trace(TRACE_MASKD, "  Status: " + rowData[3]);
                    Trace.trace(TRACE_MASKD, "  Date of last update: " + rowData[4]);
                    Trace.trace(TRACE_MASKD, "  Time of last update: " + rowData[5]);
                    Trace.trace(TRACE_MASKD, "  Description: " + rowData[6]);
                    try {
                        filenames = ((MCF)update).getFileNames();
                        Trace.trace(TRACE_MASKD, "   AnalyzeCodeFixInfoTasklet.service() - The " + Integer.toString(filenames.size()) + " filenames are: ");
                        Iterator iterator = filenames.iterator();
                        while (iterator.hasNext()) {
                            String fname = (String)iterator.next();
                            Trace.trace(TRACE_MASKD, "    > " + fname);
                        }
                        modules = ((MCF)update).getModuleNames();
                        Trace.trace(TRACE_MASKD, " [AnalyzeConsoleIntCodePanelHandler.service()] The " + Integer.toString(modules.size()) + " modules are: ");
                        iterator = modules.iterator();
                        while (iterator.hasNext()) {
                            String mod = (String)iterator.next();
                            Trace.trace(TRACE_MASKD, "    > " + mod);
                        }
                    }
                    catch (ClassCastException cce) {
                        Trace.trace(TRACE_MASKF, "   AnalyzeCodeFixInfoTasklet.service() - caught exception: " + cce);
                        filenames = new ArrayList();
                        modules = new ArrayList();
                    }
                    ArrayList<String[]> modulesTableData = new ArrayList<String[]>(filenames.size());
                    String stagingArea = ((MCF)update).getStagingAreaPath();
                    DateFormat dfDate = DateFormat.getDateInstance(3);
                    DateFormat dfTime = DateFormat.getTimeInstance(3);
                    Iterator fileIterator = filenames.iterator();
                    Iterator modIterator = modules.iterator();
                    while (fileIterator.hasNext()) {
                        String currentFileName = (String)fileIterator.next();
                        String currentModName = (String)modIterator.next();
                        String[] rowInfo = new String[5];
                        rowInfo[0] = currentFileName;
                        rowInfo[1] = currentModName;
                        File currentFile = new File(stagingArea, currentFileName);
                        Trace.trace(TRACE_MASKF, "   AnalyzeCodeFixInfoTasklet.service() - current file is [" + currentFile.getPath() + "]");
                        boolean fileExists = currentFile.exists();
                        if (!fileExists) {
                            rowInfo[2] = "-";
                        } else {
                            try {
                                rowInfo[2] = Long.toString(currentFile.length());
                            }
                            catch (SecurityException se) {
                                Trace.trace(TRACE_MASKF, " [AnalyzeConsoleIntCodePanelHandler.service()] caught exception on length(): " + se);
                                rowInfo[2] = "";
                            }
                        }
                        if (!fileExists) {
                            rowInfo[2] = "-";
                        } else {
                            try {
                                Date theDate = new Date(currentFile.lastModified());
                                rowInfo[3] = dfDate.format(theDate);
                                rowInfo[4] = dfTime.format(theDate);
                            }
                            catch (SecurityException se) {
                                Trace.trace(TRACE_MASKF, "   AnalyzeCodeFixInfoTasklet.service() - caught exception on lastModified(): " + se);
                                rowInfo[3] = "";
                                rowInfo[4] = "";
                            }
                        }
                        Trace.trace(TRACE_MASKD, "   AnalyzeCodeFixInfoTasklet.service() - rowInfo contains:");
                        Trace.trace(TRACE_MASKD, "    filename: " + rowInfo[0]);
                        Trace.trace(TRACE_MASKD, "    module: " + rowInfo[1]);
                        Trace.trace(TRACE_MASKD, "    size: " + rowInfo[2]);
                        Trace.trace(TRACE_MASKD, "    date: " + rowInfo[3]);
                        Trace.trace(TRACE_MASKD, "    time: " + rowInfo[4]);
                        modulesTableData.add(rowInfo);
                    }
                    bean.setTableData(modulesTableData);
                    this.currentPanel = this.InternalCodeChangePanelHandler;
                    response.replace("com.ibm.hwmca.base.updates.res.AnalyzeConsoleIntCodeRes", "InternalCodeFixPanel", bean);
                    break block18;
                }
                this.currentPanel.service(request, response);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "   AnalyzeCodeFixInfoTasklet.service() - caught exception: " + e);
                e.printStackTrace();
                new FrameworkLog(classLogInfo, -4348, e).log();
                Trace.trace(TRACE_MASKT, "   AnalyzeCodeFixInfoTasklet.service() - Terminate task due to unrecoverable error.");
                response.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- AnalyzeCodeFixInfoTasklet.service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> AnalyzeCodeFixInfoTasklet.logException()");
        Trace.trace(TRACE_MASKT, "   processing exception: " + throwable);
        new FrameworkLog(classLogInfo, -4346, throwable).log();
        Trace.trace(TRACE_MASKT, "<- AnalyzeCodeFixInfoTasklet.logException()");
    }

    static interface PanelHandler {
        public void service(PanelTaskletRequest var1, PanelTaskletResponse var2) throws TaskletException;
    }
}

